<script src="<?php echo e(asset('assets/js/vendors.js?v=2.1')); ?>"></script>


<!-- Core JS files -->
<script src="<?php echo e(asset('global_assets/js/jquery/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/vendor/tables/datatables/datatables.min.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/vendor/notifications/noty.min.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/demo/pages/datatables_basic.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/demo/pages/extra_noty.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/vendor/forms/selects/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset('global_assets/js/vendor/notifications/sweet_alert.min.js')); ?>"></script>


<!-- /core JS files -->

<script>

    var AIZ = AIZ || {};
    AIZ.local = {
        nothing_selected: 'Nothing selected',
        nothing_found: 'Nothing found',
        choose_file: 'Choose file',
        file_selected: 'File selected',
        files_selected: 'Files selected',
        add_more_files: 'Add more files',
        adding_more_files: 'Adding more files',
        drop_files_here_paste_or: 'Drop files here, paste or',
        browse: 'Browse',
        upload_complete: 'Upload complete',
        upload_paused: 'Upload paused',
        resume_upload: 'Resume upload',
        pause_upload: 'Pause upload',
        retry_upload: 'Retry upload',
        cancel_upload: 'Cancel upload',
        uploading: 'Uploading',
        processing: 'Processing',
        complete: 'Complete',
        file: 'File',
        files: 'Files',
    }

    $(document).ready(function () {

        $('#info_table').on('page.dt', function () {
            $('#loading').show();
        });
        $('#info_table').on('draw.dt', function () {
            $('#loading').hide();
        });
        $('#loading').hide();
        var swalInit = swal.mixin({
            buttonsStyling: false,
            confirmButtonClass: 'btn btn-outline-danger',
            cancelButtonClass: 'btn btn-light'
        });
        //button create
        $("#create_form_vertical").click(function () {
            $(document).off('focusin.modal');
            $(".validation-invalid-label").addClass('d-none')
            $('#main_form').trigger("reset");
            $('#modal_form_vertical').modal('show');
            $('select').trigger('change');
            $(".file-preview").empty()
            $(".file-amount").html('0 File Amount Selected')
            $(".selected-files").val('')
        })

        // for creating
        $(document).on("submit", "#main_form", function (e) {

            e.preventDefault();
            $(".validation-invalid-label").removeClass('d-none')


            $.ajax({
                url: $(this).attr('action'),
                method: $(this).attr('method'),
                data: new FormData(this),
                processData: false,
                dataType: 'json',
                contentType: false,
                beforeSend: function () {
                    $(document).find('span.error-text').text('');
                    $('.submit_form').addClass('disabled');
                    $('.send_icon').removeClass('icon-paperplane');
                    $('.send_icon').addClass('ph-spinner spinner');
                },
                complete: function () {
                    $('.submit_form').removeClass('disabled');
                    $('.send_icon').removeClass('ph-spinner spinner');
                    $('.send_icon').addClass('icon-paperplane');

                },
                error: function (data, textStatus, errorThrown) {
                    if (data.status === 422) {
                        var errors = $.parseJSON(data.responseText);
                        $.each(errors, function (key, value) {
                            // console.log(key+ " " +value);
                            $('#response').addClass("alert alert-danger");

                            if ($.isPlainObject(value)) {
                                $.each(value, function (key, value) {
                                    console.log(key + " " + value);
                                    $('#response').show().append(value + "<br/>");
                                    console.log(value)
                                    new Noty({
                                        text: value,
                                        type: 'error'
                                    }).show();
                                });


                            } else {
                                $('#response').show().append(value + "<br/>"); //this is my div with messages
                            }
                        });

                    } else if (data.status == 403) {
                        new Noty({
                            text: 'Please Login With A Specific Role',
                            type: 'error'
                        }).show();
                    } else if (data.status == 404) {
                        new Noty({
                            text: 'This Page Not Found',
                            type: 'error'
                        }).show();
                    } else {
                        new Noty({
                            text: 'Something went wrong',
                            type: 'error'
                        }).show();
                    }
                },
                success: function (data) {
                    if (data.status == 0) {
                        $.each(data.error, function (prefix, val) {
                            $('span.' + prefix + '_error').text(val[0]);
                        });
                    } else {
                        new Noty({
                            text: 'Successfully data inserted',
                            type: 'success'
                        }).show();
                        $('#modal_form_vertical').modal('hide');
                        $('#modal_form_vertical_reply').modal('hide');
                        $('#info_table').DataTable().ajax.reload();
                        $('#main_form').trigger("reset");
                        $('select').trigger('change');

                    }
                }
            });

        })


        //for updating
        $(document).on("submit", "#main_form_edit", function (e) {
            e.preventDefault();
            $.ajax({
                url: $(this).attr('action'),
                method: $(this).attr('method'),
                data: new FormData(this),
                processData: false,
                dataType: 'json',
                contentType: false,
                beforeSend: function () {
                    $(document).find('span.error-text').text('');
                    $('.submit_form').addClass('disabled');
                    $('.send_icon').removeClass('icon-paperplane');
                    $('.send_icon').addClass('ph-spinner spinner');
                },
                complete: function () {
                    $('.submit_form').removeClass('disabled');
                    $('.send_icon').removeClass('ph-spinner spinner');
                    $('.send_icon').addClass('icon-paperplane');

                },
                error: function (data, textStatus, errorThrown) {
                    if (data.status === 422) {
                        var errors = $.parseJSON(data.responseText);
                        $.each(errors, function (key, value) {
                            // console.log(key+ " " +value);
                            $('#response').addClass("alert alert-danger");

                            if ($.isPlainObject(value)) {
                                $.each(value, function (key, value) {
                                    console.log(key + " " + value);
                                    $('#response').show().append(value + "<br/>");
                                    console.log(value)
                                    new Noty({
                                        text: value,
                                        type: 'error'
                                    }).show();
                                });


                            } else {
                                $('#response').show().append(value + "<br/>"); //this is my div with messages
                            }
                        });

                    } else if (data.status == 403) {
                        new Noty({
                            text: 'Please Login With A Specific Role',
                            type: 'error'
                        }).show();
                    } else if (data.status == 404) {
                        new Noty({
                            text: 'This Page Not Found',
                            type: 'error'
                        }).show();
                    } else {
                        new Noty({
                            text: 'Something went wrong',
                            type: 'error'
                        }).show();
                    }
                },
                success: function (data) {
                    if (data.status == "fail") {

                        $.each(data.error, function (prefix, val) {
                            $('span.' + prefix + '_error').text(val[0]);
                        });
                    } else {
                        new Noty({
                            text: 'Successfully Data Updated',
                            type: 'success'
                        }).show();
                        $('#modal_form_vertical_edit').modal('hide');
                        $('#info_table').DataTable().ajax.reload();
                        $('#main_form_edit').trigger("reset");

                    }
                }
            });

        })

        // for deleting
        $(document).delegate("#delete", "click", function () {


            var id = $(this).data("id");
            var route = $(this).data("route");

            swalInit.fire({
                title: 'Are you sure?',
                text: 'You will not be able to recover this imaginary file!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.value == true) {
                    $.ajax({
                        type: 'DELETE',
                        url: route,
                        data: {
                            "_token": "<?php echo e(csrf_token()); ?>",
                            id: id
                        },
                        error: function (data, textStatus, errorThrown) {
                            if (data.status === 422) {
                                var errors = $.parseJSON(data.responseText);
                                $.each(errors, function (key, value) {
                                    // console.log(key+ " " +value);
                                    $('#response').addClass("alert alert-danger");

                                    if ($.isPlainObject(value)) {
                                        $.each(value, function (key, value) {
                                            console.log(key + " " + value);
                                            $('#response').show().append(value + "<br/>");
                                            console.log(value)
                                            new Noty({
                                                text: value,
                                                type: 'error'
                                            }).show();
                                        });


                                    } else {
                                        $('#response').show().append(value + "<br/>"); //this is my div with messages
                                    }
                                });

                            } else if (data.status == 403) {
                                new Noty({
                                    text: 'Please Login With A Specific Role',
                                    type: 'error'
                                }).show();
                            } else if (data.status == 404) {
                                new Noty({
                                    text: 'This Page Not Found',
                                    type: 'error'
                                }).show();
                            } else {
                                new Noty({
                                    text: 'Something went wrong',
                                    type: 'error'
                                }).show();
                            }
                        },
                        success: function (response) {


                            if (response.status == true) {
                                new Noty({
                                    text: 'Record deleted successfully!',
                                    type: 'success'
                                }).show();
                                $('#info_table').DataTable().ajax.reload();
                                $('#healthHistoryTable').DataTable().ajax.reload();
                                $('#PriscriptionTable').DataTable().ajax.reload();
                                $('#medicalFilesTable').DataTable().ajax.reload();
                            }

                        }
                    });
                } else if (result.isDenied) {
                    Swal.fire('Changes are not saved', '', 'info')
                }
            })


            return false;

        })

        //for change status
        $(document).delegate(".checkbox_change_status", "change", function () {

            var id = $(this).data("id");
            var route = $(this).data("route");
            $.ajax({
                type: 'GET',
                url: route,
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    id: id
                },
                error: function (data, textStatus, errorThrown) {
                    if (data.status === 422) {
                        var errors = $.parseJSON(data.responseText);
                        $.each(errors, function (key, value) {
                            // console.log(key+ " " +value);
                            $('#response').addClass("alert alert-danger");

                            if ($.isPlainObject(value)) {
                                $.each(value, function (key, value) {
                                    console.log(key + " " + value);
                                    $('#response').show().append(value + "<br/>");
                                    console.log(value)
                                    new Noty({
                                        text: value,
                                        type: 'error'
                                    }).show();
                                });


                            } else {
                                $('#response').show().append(value + "<br/>"); //this is my div with messages
                            }
                        });

                    } else if (data.status == 403) {
                        new Noty({
                            text: 'Please Login With A Specific Role',
                            type: 'error'
                        }).show();
                    } else if (data.status == 404) {
                        new Noty({
                            text: 'This Page Not Found',
                            type: 'error'
                        }).show();
                    } else {
                        new Noty({
                            text: 'Something went wrong',
                            type: 'error'
                        }).show();
                    }
                },
                success: function (response) {

                    if (response.status == true) {
                        new Noty({
                            text: 'Successfully status change',
                            type: 'success'
                        }).show();
                        $('#info_table').DataTable().ajax.reload();
                    }

                }
            });


            return false;

        })


        // for translating
        $(".translate").click(function () {
            var name_en = $(".name_en").val();
            var name_ku = $(".name_ku").val();
            var name_ar = $(".name_ar").val();
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('translate.all')); ?>",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    name_en: name_en,
                    name_ku: name_ku,
                    name_ar: name_ar,
                },
                success: function (response) {
                    $(".name_en").val(response.name_en);
                    $(".name_ku").val(response.name_ku);
                    $(".name_ar").val(response.name_ar);
                }
            });
        });
        $(".translate_update").click(function () {
            var name_en = $(".name_en").val();
            var name_ku = $(".name_ku").val();
            var name_ar = $(".name_ar").val();
            $.ajax({
                type: 'GET',
                url: "<?php echo e(route('translate.all')); ?>",

                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    name_en: name_en,
                    name_ku: name_ku,
                    name_ar: name_ar,
                },
                beforeSend: function () {

                    $('.icon_translate').removeClass('icon-earth');
                    $('.icon_translate').addClass('fa fa-spinner fa-spin');
                },
                complete: function () {
                    $('.icon_translate').removeClass('fa fa-spinner fa-spin');
                    $('.icon_translate').addClass('icon-earth');

                },
                success: function (response) {

                    $(".name_en").val(response.name_en);
                    $(".name_ku").val(response.name_ku);
                    $(".name_ar").val(response.name_ar);
                }
            });
        });
    })
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/layouts/main_script.blade.php ENDPATH**/ ?>