<!-- Vertical form modal -->
<div id="modal_form_vertical" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h6 class="modal-title"><?php echo app('translator')->get('translate.add_attribute'); ?></h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('attribute.store')); ?>" class="form-validate-jquery main_form"
                    id="main_form">
                    <?php echo e(csrf_field()); ?>


                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en" class="nav-link active" data-toggle="tab">En</a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku" class="nav-link" data-toggle="tab">Ku</a></li>
                        <li class="nav-item"><a href="#lang_ar" class="nav-link" data-toggle="tab">Ar</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name" required
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2">Select Category</label>
                                <select class="form-control" id="category_id" name="category_id">
                                    <option value="0" selected>No Selectedt</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                        <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo $__env->make('categories.child_category', [
                                                'child_category' => $childCategory,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.attribute_type'); ?></label>
                                <select name="attribute_type" id="attribute_type" class="form-control">
                                    <option value="textarea" selected><?php echo app('translator')->get('translate.textarea'); ?></option>
                                    <option value="single_select"><?php echo app('translator')->get('translate.single_select'); ?></option>
                                    <option value="multi_select"><?php echo app('translator')->get('translate.multi_select'); ?></option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.attribute_priority'); ?></label>
                                <select name="priority" id="priority" class="form-control">
                                    <option value="optional" selected><?php echo app('translator')->get('translate.optional'); ?></option>
                                    <option value="required"><?php echo app('translator')->get('translate.required'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name_ku"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name_ar"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                        </div>
                    </div>



                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical form modal -->
<?php /**PATH /Users/miladmajeed/Desktop/Gigant/Sale-Point/resources/views/attribute/create.blade.php ENDPATH**/ ?>