<script src="<?php echo e(asset("global_assets/js/plugins/forms/selects/select2.min.js")); ?>"></script>
<script src="./global_assets/js/plugins/notifications/pnotify.min.js"></script>

<script>
    function load_js() {
        var head = document.getElementsByTagName('head')[0];
        var script = document.createElement('script');
        script.src = "<?php echo e(asset('assets/js/aiz-core.js?v=1')); ?>";
        head.appendChild(script);
    }

    $(document).ready(function () {
        $("#category_id").select2({
            dropdownParent: $('#modal_form_vertical')
        });
        $("#attribute_type").select2({
            dropdownParent: $('#modal_form_vertical')

        });
        $("#priority").select2({
            dropdownParent: $('#modal_form_vertical')

        });
        $("#priority_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')

        });
        var swalInit = swal.mixin({
            buttonsStyling: false,
            confirmButtonClass: 'btn btn-outline-danger',
            cancelButtonClass: 'btn btn-light'
        });

        $("#info_table").DataTable({
            processing: true,
            "order": [[0, "desc"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/<?php echo e((App::getLocale() == 'ckb' ) ? 'ku' : App::getLocale()); ?>.json",
                searchPlaceholder: "<?php echo e(__('translate.search_records')); ?>"
            },
            serverSide: true,
            columnDefs: [{
                targets: [3]
            }],
            ajax: {
                url: "<?php echo e(route('attribute.data')); ?>"
            },
            columns: [
                {
                    data: "id",
                    name: "id"
                },
                {
                    data: "name",
                    name: "name",
                },
                {
                    data: "attribute_type",
                    name: "attribute_type",
                },
                {
                    data: "attribute_value",
                    name: "attribute_value",
                },
                {
                    data: "category",
                    name: "category",
                },
                {
                    data: "checkbox",
                    name: "checkbox",
                },
                {
                    data: "created_at",
                    name: "created_at"
                },
                {
                    data: "created_by",
                    name: "created_by"
                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center",
                }
            ]
        });


        var info_table_attribute_value = $("#info_table_attribute_value").DataTable({
            "order": [[0, "desc"]],
            columnDefs: [{
                targets: [3]
            }],
        });
        $(document).on("click", "#edit", function () {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/attribute')); ?>/" + id + '/edit',
                type: "GET",
                dataType: "json",
                success: function (data) {
                    $("#id").val(data.data.id);
                    $("#name").val(data.names.en);
                    $("#name_ku").val(data.names.ku);
                    $("#name_ar").val(data.names.ar);
                    var attributeType = data.data.attribute_type;
                    var attributePriority = data.data.priority;
                    $("#attribute_type_edit").val(attributeType).trigger('change');
                    $("#priority_edit").val(attributePriority).trigger('change');
                    const project_category = data.data.category_id;
                    $("#attribute_category_id_edit").val(project_category).trigger('change');
                    $('#attribute_category_id_edit>option[value="' + project_category + '"]')
                    $('#main_form_edit').attr('action', data.route);
                    $("#modal_form_vertical_edit").modal("show");
                }
            });
        })
        $("#attribute_category_id_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });
        $("#attribute_type_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });

        $(document).on("click", ".edit_another", function () {
            var id = $(this).data('id');
            var value = $(this).parent().parent().find('.value').val();
            var value_ku = $(this).parent().parent().find('.value_ku').val();
            var value_ar = $(this).parent().parent().find('.value_ar').val();

            $.ajax({
                url: "<?php echo e(url('/attribute_value')); ?>/" + id,
                type: "PUT",
                dataType: "json",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    value: value,
                    value_ku: value_ku,
                    value_ar: value_ar,
                },
                beforeSend: function () {
                    $(document).find('span.error-text').text('');
                    $('.check_' + id + '').removeClass('fa fa-check');
                    $('.check_' + id + '').addClass('fa fa-spinner fa-spin');
                },
                complete: function () {
                    $('.check_' + id + '').removeClass('fa fa-spinner fa-spin');
                    $('.check_' + id + '').addClass('fa fa-check');

                },
                error: function (data, textStatus, errorThrown) {
                    if (data.status === 422) {
                        var errors = $.parseJSON(data.responseText);
                        $.each(errors, function (key, value) {
                            $('#response').addClass("alert alert-danger");

                            if ($.isPlainObject(value)) {
                                $.each(value, function (key, value) {
                                    console.log(key + " " + value);
                                    $('#response').show().append(value + "<br/>");
                                    console.log(value)
                                    new PNotify({
                                        title: "Error Field",
                                        text: value,
                                        addclass: 'bg-danger border-danger text-white',
                                        delay: 3000
                                    });
                                });


                            } else {
                                $('#response').show().append(value + "<br/>"); //this is my div with messages
                            }
                        });

                    } else if (data.status == 403) {
                        new PNotify({
                            title: "Not Authoorized",
                            text: "Please Login With A Specific Role",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    } else if (data.status == 404) {
                        new PNotify({
                            title: "Not Found",
                            text: "This Page Not Found",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    } else {
                        new PNotify({
                            title: "Wrong",
                            text: "Something went wrong",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    }
                },
                success: function (data) {
                    new PNotify({
                        // title: 'Success notice',
                        text: `${data.message}`,
                        addclass: 'bg-success border-success text-white',
                        delay: 3000
                    });
                    $('#info_table').DataTable().ajax.reload();
                }
            });
        })

        $(document).on("click", "#add_value", function () {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/attribute')); ?>/" + id + '/get_attribute_value',
                type: "GET",
                dataType: "json",
                success: function (data) {
                    $('.attribute_value').html(data.html)
                    
                    
                    

                    
                    $("#modal_form_vertical_attribute_value").modal("show");
                }
            });
        })

        // for creating
        $(document).on("submit", "#main_form_add_attribute_value", function (e) {

            e.preventDefault();
            $(".validation-invalid-label").removeClass('d-none')
            $.ajax({
                url: $(this).attr('action'),
                method: $(this).attr('method'),
                data: new FormData(this),
                processData: false,
                dataType: 'json',
                contentType: false,
                beforeSend: function () {
                    $(document).find('span.error-text').text('');
                    $('.submit_form').addClass('disabled');
                    $('.send_icon').removeClass('icon-paperplane');
                    $('.send_icon').addClass('fa fa-spinner fa-spin');
                },
                complete: function () {
                    $('.submit_form').removeClass('disabled');
                    $('.send_icon').removeClass('fa fa-spinner fa-spin');
                    $('.send_icon').addClass('icon-paperplane');

                },
                error: function (data, textStatus, errorThrown) {
                    if (data.status === 422) {
                        var errors = $.parseJSON(data.responseText);
                        $.each(errors, function (key, value) {
                            // console.log(key+ " " +value);
                            $('#response').addClass("alert alert-danger");

                            if ($.isPlainObject(value)) {
                                $.each(value, function (key, value) {
                                    console.log(key + " " + value);
                                    $('#response').show().append(value + "<br/>");
                                    console.log(value)
                                    new PNotify({
                                        title: "Error Field",
                                        text: value,
                                        addclass: 'bg-danger border-danger text-white',
                                        delay: 3000
                                    });
                                });


                            } else {
                                $('#response').show().append(value + "<br/>"); //this is my div with messages
                            }
                        });

                    } else if (data.status == 403) {
                        new PNotify({
                            title: "Not Authoorized",
                            text: "Please Login With A Specific Role",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    } else if (data.status == 404) {
                        new PNotify({
                            title: "Not Found",
                            text: "This Page Not Found",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    } else {
                        new PNotify({
                            title: "Wrong",
                            text: "Something went wrong",
                            addclass: 'bg-danger border-danger text-white',
                            delay: 3000
                        });
                    }
                },
                success: function (data) {
                    $("#info_table_attribute_value").DataTable().ajax.reload();

                    // if (data.status == 0) {
                    //     $.each(data.error, function (prefix, val) {
                    //         $('span.' + prefix + '_error').text(val[0]);
                    //     });
                    // } else {
                    //     // new PNotify({
                    //     //     // title: 'Success notice',
                    //     //     text: `${data.message}`,
                    //     //     addclass: 'bg-success border-success text-white',
                    //     //     delay: 3000
                    //     // });
                    // }



                }
            });


        })

        // for deleting
        $(document).delegate(".delete_another", "click", function () {


            var id = $(this).data("id");
            var route = $(this).data("route");

            swalInit.fire({
                title: 'Are you sure?',
                text: 'You will not be able to recover this imaginary file!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.value == true) {
                    $.ajax({
                        type: 'DELETE',
                        url: route,
                        data: {
                            "_token": "<?php echo e(csrf_token()); ?>",
                            id: id
                        }, error: function (jqXHR, textStatus, errorThrown) {
                            new PNotify({
                                title: 'Something went wrong',
                                text: `Please try again`,
                                addclass: 'bg-danger border-danger',
                                delay: 3000
                            });
                        },
                        success: function (response) {


                            if (response.status == true) {
                                new PNotify({
                                    // title: 'Success notice',
                                    text: "Record deleted successfully!",
                                    addclass: 'bg-success border-success text-white',
                                    delay: 3000
                                });


                            }
                            $("#info_table_attribute_value").DataTable().ajax.reload();




                        }
                    });
                } else if (result.isDenied) {
                    Swal.fire('Changes are not saved', '', 'info')
                }
            })


            return false;

        })

    })

</script>
<?php /**PATH /Users/miladmajeed/Desktop/Gigant/Sale-Point/resources/views/attribute/script.blade.php ENDPATH**/ ?>