<!-- Vertical form modal -->
<div id="modal_form_vertical" class="modal fade" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-full">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h6 class="modal-title"><?php echo app('translator')->get('translate.add_package'); ?></h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('packages.store')); ?>" class="form-validate-jquery main_form"
                    id="main_form">
                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en" class="nav-link active"
                                data-toggle="tab"><?php echo app('translator')->get('translate.en'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku" class="nav-link" data-toggle="tab"><?php echo app('translator')->get('translate.ku'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ar" class="nav-link" data-toggle="tab"><?php echo app('translator')->get('translate.ar'); ?></a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title" required
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" name="description" placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>



                            <div class="form-group row">
                                <label class="mb-2"><?php echo app('translator')->get('translate.Image'); ?></label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image"
                                    data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            <?php echo app('translator')->get('translate.browse'); ?></div>
                                    </div>
                                    <div class="form-control file-amount"><?php echo app('translator')->get('translate.choose_file'); ?></div>
                                    <input type="hidden" name="image" required class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                            </div>

                            <div class="row">

                                <div class="col-lg-4">
                                    <div class="form-group mb-3">
                                        <label class="mb-2"><?php echo app('translator')->get('translate.price'); ?> (IQD)</label>
                                        <input type="text" class="form-control" name="price" required
                                               placeholder="<?php echo app('translator')->get('translate.price'); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group mb-3">
                                        <label class="mb-2">Package Days</label>
                                        <input type="text" class="form-control" value="1" name="package_days" required
                                               placeholder="Package Days">
                                    </div>
                                </div>

                                <div class="col-lg-3">
                                    <div class="form-group mb-3">
                                        <label class="mb-2" for="favcolor">Color Code</label><br>
                                        <input type="color" id="favcolor" name="code" value="#ff0000">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ku"
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" name="description_ku" placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ar"
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('translate.description'); ?></label>
                                    <textarea rows="7" cols="3" class="form-control" name="description_ar"
                                        placeholder="<?php echo app('translator')->get('translate.description'); ?>"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/packages/create.blade.php ENDPATH**/ ?>