<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom_uploader.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title'); ?>
    Notification
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
    <!-- Basic button -->
    <div class="page-header page-header-light border rounded mb-3">
        <div class="page-header-content d-flex">
            <div class="page-title">
                <h5 class="mb-0">Section Notification</h5>
                <div class="text-muted mt-1"></div>
            </div>
            <div class="my-auto ms-auto">

            </div>
        </div>
        <div class="page-header-content border-top">
            <div class="breadcrumb">
                <a href="/" class="breadcrumb-item py-2"><?php echo app('translator')->get('translate.home'); ?></a>
                <span class="breadcrumb-item active py-2">Notification</span>
            </div>
        </div>
    </div>
    <!-- /basic button -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-body">
            <form method="post" action="<?php echo e(route('notifications.send')); ?>" class="form-validate-jquery main_form"
                  id="main_form">
                <?php echo csrf_field(); ?>
                <div class="form-group <?php echo e($errors->has('title') ? ' has-error' : ''); ?>">
                    <label for="title">Title</label>
                    <div class="input-group mb-3">
                        <input type="text" name="title" required class="form-control" id="title"
                               placeholder="Hello Everyone !!" value="<?php echo e(old('title')); ?>" data-maxlength="120">
                        <div class="input-group-append">
                            <span class="input-group-text">120</span>
                        </div>
                    </div>

                </div>

                <div class="form-group">
                    <label for="short_description">Short Description</label>
                    <div class="input-group">
                        <textarea name="short_description" required id="short_description" class="form-control"
                                  placeholder="You Can Buy Course And Have Fun .. " data-maxlength="220"></textarea>
                        <div class="input-group-append">
                            <span class="input-group-text">220</span>
                        </div>
                    </div>
                </div>


                <!-- Switchery single -->
               <div class="row">
                   <div class="col-lg-6">
                       <div class="form-group row">
                           <label class="col-lg-3 col-form-label">Send Type</label>

                           <select name="send_type" id="send_type" class="form-control">
                               <option value="all">All Users</option>
                               <option value="specific">Specific User</option>
                           </select>

                       </div>
                   </div>

                   <div class="col-lg-6 user_select d-none">
                       <div class="form-group row">
                           <label class="col-lg-3 col-form-label">Users</label>

                           <select name="user_id[]" id="user_id" class="form-control" multiple>

                           </select>

                       </div>
                   </div>
               </div>
                <!-- /switchery single -->

                <div class="text-end">
                    <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                            class="icon-paperplane ms-2 send_icon"></i></button>
                </div>
            </form>

        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset("global_assets/js/plugins/forms/selects/select2.min.js")); ?>"></script>
    <script>


        $("#user_id").select2({
            placeholder: "Search For Users",
            ajax: {
                url: "<?php echo e(route('users.get_users')); ?>",
                type: "post",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        _token: "<?php echo e(csrf_token()); ?>",
                        search: params.term // search term
                    };
                },
                processResults: function (response) {

                    var results = [];
                    for (var i = 0; i < response.length; i++) {
                        results.push({
                            id: response[i].id,
                            text: response[i].text,
                            disabled: response[i].locked === 1
                        });
                    }
                    return {
                        results: results
                    };
                },
                cache: true
            }

        });


        $(document).ready(function () {

            $("#send_type").select2();
            $("#send_type").change(function () {
                var type = $(this).val();
                if (type == 'all') {
                    $(".user_select").addClass('d-none')
                } else {
                    $(".user_select").removeClass('d-none')
                }
            });




        })
    </script>

<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/notifications/send_notifications.blade.php ENDPATH**/ ?>