<script src="<?php echo e(asset('assets/js/aiz-core.js?v=1')); ?>"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
<script src="<?php echo e(asset('global_assets/js/plugins/forms/selects/select2.min.js')); ?>"></script>

<script>
    $(document).ready(function() {
        $("#currency_type").select2({
            dropdownParent: $('#modal_form_vertical')
        });
        $("#currency_type_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });
        $("#info_table").DataTable({
            processing: true,
            "order": [
                [0, "desc"]
            ],
            "language": {
                
                searchPlaceholder: "<?php echo e(__('translate.search_records')); ?>"
            },
            serverSide: true,
            columnDefs: [{
                targets: [3]
            }],
            ajax: {
                url: "<?php echo e(route('packages.data')); ?>"
            },
            columns: [{
                    data: "id",
                    name: "id"
                },
                {
                    data: "title",
                    name: "title",
                },
                {
                    data: "price",
                    name: "price",
                },   {
                    data: "package_days",
                    name: "package_days",
                },
                {
                    data: "image",
                    name: "image",
                },
                {
                    data: "checkbox",
                    name: "checkbox",
                },
                {
                    data: "created_at",
                    name: "created_at"
                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center",
                }
            ]
        });
        $(document).on("click", "#edit", function() {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/packages')); ?>/" + id + '/edit',
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $("#id").val(data.data.id);
                    $("#title").val(data.data.raw_translation_title.en);
                    $("#price").val(data.data.price);
                    $("#title_ku").val(data.data.raw_translation_title.ckb);
                    $("#title_ar").val(data.data.raw_translation_title.ar);
                    $("#description").val(data.data.raw_translation_description.en);
                    $("#code").val(data.data.code);
                    $("#description_ku_edit").val(data.data.raw_translation_description
                        .ckb);
                    $("#description_ar_edit").val(data.data.raw_translation_description.ar);
                    $("#currency_type_edit").val(data.data.currency_type);
                    var status = data.data.currency_type;
                    $("#currency_type_edit").val(status).trigger('change');

                    $("#image").val(data.data.image);
                    $("#package_days").val(data.data.package_days);
                    $('.update_section').html(data.html);
                    $('#main_form_edit').attr('action', data.route);
                    $("#modal_form_vertical_edit").modal("show");
                    AIZ.uploader.previewGenerate();
                }
            });
        })
        $("#project_category_id").select2({
            dropdownParent: $('#modal_form_vertical')
        });
        $("#project_category_id_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });
    })
</script>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/packages/script.blade.php ENDPATH**/ ?>