
<script>
    $(document).ready(function () {
        $("#role").select2({
            dropdownParent: $('#modal_form_vertical')
        });
        $("#role_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });

        $("#info_table").DataTable({
            processing: true,
            "order": [[0, "desc"]],
            serverSide: true,
            ajax: {
                url: "<?php echo e(route('admin.data')); ?>"
            },
            columns: [
                {
                    data: "id",
                    name: "id"
                },
                {
                    data: "name",
                    name: "name",
                    "class": "text-center"
                },
                {
                    data: "email",
                    name: "email",
                    "class": "text-center"
                },
                {
                    data: "phone",
                    name: "phone",
                    "class": "text-center"
                },
                {
                    data: "role",
                    name: "role",
                    "class": "text-center"

                },
                {
                    data: "checkbox",
                    name: "checkbox",
                    "class": "text-center"

                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center"
                }
            ]
        });
        $(document).on("click", "#edit", function () {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/admin')); ?>/" + id+'/edit',
                type: "GET",
                dataType: "json",
                success: function (data) {

                    $("#id").val(data.data.id);
                    $("#name").val(data.data.name);
                    $("#email").val(data.data.email);
                    $("#phone").val(data.data.phone);
                    $('#main_form_edit').attr('action', data.route);
                    var role = data.data.role_id;

                    console.log(role)
                    $("#role_edit").val(role).trigger('change');
                    $('#role_edit>option[value="' + role + '"]').prop('selected', true);
                    $("#modal_form_vertical_edit").modal("show");
                }
            });
        })
    })

</script>
<?php /**PATH /Users/miladmajeed/Desktop/Gigant/Sale-Point/resources/views/admin/script.blade.php ENDPATH**/ ?>