<?php $__env->startSection('title'); ?>
    Hello
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="container">
        <div class="main-body">
            <div class="row gutters-sm">
                <div class="col-md-4 mb-3">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex flex-column align-items-center text-center">
                                <img src="https://bootdey.com/img/Content/avatar/avatar7.png" alt="Admin"
                                    class="rounded-circle" width="150">
                                <div class="mt-3">
                                    <h4><?php echo e($user->fullname); ?></h4>
                                    <p class="text-secondary mb-1"><?php echo e($user->phone); ?></p>
                                    <div id="mydiv">
                                        <?php if($user->active == 1): ?>
                                            <label class="custom-control custom-control-success custom-checkbox mb-2">
                                                <input type="checkbox"
                                                    class="custom-control-input checkbox_change_status_customer" checked
                                                    data-route="<?php echo e(route('users.status_change', [$user->id])); ?>">
                                                <span class="custom-control-label">Active</span>
                                            </label>
                                        <?php else: ?>
                                            <label class="custom-control custom-control-success custom-checkbox mb-2">
                                                <input type="checkbox"
                                                    class="custom-control-input checkbox_change_status_customer"
                                                    data-route="<?php echo e(route('users.status_change', [$user->id])); ?>">
                                                <span class="custom-control-label text-danger">Suspended</span>
                                            </label>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card mb-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">Full Name</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    <?php echo e($user->fullname); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">Email</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    <?php echo e($user->email); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">Phone</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    <?php echo e($user->phone); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">Gender</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    <?php echo e($user->gender); ?>

                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-sm-3">
                                    <h6 class="mb-0">Date Of Birth</h6>
                                </div>
                                <div class="col-sm-9 text-secondary">
                                    <?php echo e($user->dob); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            $(document).ready(function() {
                $(document).on("click", "#view_form_vertical_address", function() {
                    var id = <?php echo e($user->id); ?>

                    $.ajax({
                        url: "<?php echo e(url('/users')); ?>/" + id + '/address',
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            $("#modal_form_vertical_address").modal("show");
                        }
                    });
                })

                $(document).delegate(".checkbox_change_status_customer", "change", function() {
                    var checkbox = $(this); // the checkbox
                    var label = checkbox.next('.custom-control-label'); // the associated label

                    var id = checkbox.data("id");
                    var route = checkbox.data("route");

                    console.log('Checkbox changed - ID:', id, 'Route:', route); // Debugging line

                    $.ajax({
                        type: 'GET',
                        url: route,
                        data: {
                            "_token": "<?php echo e(csrf_token()); ?>",
                            id: id
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            console.error('AJAX error:', textStatus, errorThrown); // Debugging line
                            // ... existing error handling code ...
                        },
                        success: function(response) {
                            console.log('AJAX success - Response:', response); // Debugging line

                            if (response.status === true) {
                                var isActive = response.active == 1; // or true, depending on your setup
                                var newText = isActive ? 'Active' : 'Suspended'; // determine the status based on the "active" field
                                label.text(newText); // update the label's text

                                // Update classes based on the new status
                                if (isActive) {
                                    label.removeClass('text-danger').addClass('text-success');
                                } else {
                                    label.removeClass('text-success').addClass('text-danger');
                                }

                                new Noty({
                                    text: 'Status Successfully Changed',
                                    type: 'success'
                                }).show();
                            }
                        }
                    });

                    return false; // prevent default action
                });

            })
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/user/view.blade.php ENDPATH**/ ?>