<script src="<?php echo e(asset('assets/js/aiz-core.js')); ?>"></script>
<script src="<?php echo e(asset("global_assets/js/plugins/forms/selects/select2.min.js")); ?>"></script>
<script>
    $("#add_id").select2({
        placeholder: "Search For Adds",
        dropdownParent: $("#modal_form_vertical"),
        ajax: {
            url: "<?php echo e(route('banners.get_adds')); ?>",
            type: "post",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    _token: "<?php echo e(csrf_token()); ?>",
                    search: params.term // search term
                };
            },
            processResults: function (response) {

                var results = [];
                for (var i = 0; i < response.length; i++) {
                    results.push({
                        id: response[i].id,
                        text: response[i].text,
                        disabled: response[i].locked === 1
                    });
                }
                return {
                    results: results
                };
            },
            cache: true
        }

    });


    $(document).ready(function () {

        $("#banner_type").select2({
            dropdownParent: $('#modal_form_vertical')

        });
        $("#banner_type").change(function () {

            var type = $(this).val();

            if (type == 'product') {
                $(".link_input").addClass('d-none');
                $(".adds_input").removeClass('d-none');

            } else if (type == 'link') {
                $(".link_input").removeClass('d-none');
                $(".adds_input").addClass('d-none');
            } else {
                $(".link_input").addClass('d-none');
                $(".adds_input").addClass('d-none');
            }


        });



        $("#info_table").DataTable({
            processing: true,
            "order": [[0, "desc"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/<?php echo e((App::getLocale() == 'ckb' ) ? 'ku' : App::getLocale()); ?>.json",
                searchPlaceholder: "<?php echo e(__('translate.search_records')); ?>"
            },
            serverSide: true,
            columnDefs: [{
                targets: [3]
            }],
            ajax: {
                url: "<?php echo e(route('banners.data')); ?>"
            },
            columns: [
                {
                    data: "id",
                    name: "id"
                },
                {
                    data: "title",
                    name: "title",
                },
                {
                    data: "slug",
                    name: "slug",
                },
                {
                    data: "checkbox",
                    name: "checkbox",
                },
                {
                    data: "image",
                    name: "image"
                },
                {
                    data: "initial_date",
                    name: "initial_date"
                },
                {
                    data: "final_date",
                    name: "final_date"
                },
                {
                    data: "created_at",
                    name: "created_at"
                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center",
                }
            ]
        });
        $(document).on("click", "#edit", function () {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/banners')); ?>/" + id + '/edit',
                type: "GET",
                dataType: "json",
                success: function (data) {
                    $(".update_section").html(data.html)
                    $("#modal_form_vertical_edit").modal('show')

                    AIZ.uploader.previewGenerate()
                }
            });
        })
    })
</script>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/banner/script.blade.php ENDPATH**/ ?>