<script src="<?php echo e(asset('assets/js/aiz-core.js?v=1')); ?>"></script>
<script src="https://cdn.ckeditor.com/ckeditor5/35.4.0/classic/ckeditor.js"></script>
<script src="<?php echo e(asset('global_assets/js/plugins/forms/selects/select2.min.js')); ?>"></script>

<script>
    $(document).ready(function() {
        $("#currency_type").select2({
            dropdownParent: $('#modal_form_vertical')
        });
        $("#currency_type_edit").select2({
            dropdownParent: $('#modal_form_vertical_edit')
        });
        $("#info_table").DataTable({
            processing: true,
            "order": [
                [0, "desc"]
            ],
            "language": {
                
                searchPlaceholder: "<?php echo e(__('translate.search_records')); ?>"
            },
            serverSide: true,
            columnDefs: [{
                targets: [3]
            }],
            ajax: {
                url: "<?php echo e(route('location.data')); ?>"
            },
            columns: [{
                    data: "id",
                    name: "id"
                },
                {
                    data: "title",
                    name: "title",
                },
                {
                    data: "longitude",
                    name: "longitude",
                },   {
                    data: "latitude",
                    name: "latitude",
                },
                {
                    data: "checkbox",
                    name: "checkbox",
                },
                {
                    data: "created_at",
                    name: "created_at"
                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center",
                }
            ]
        });
        $(document).on("click", "#edit", function() {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/location')); ?>/" + id + '/edit',
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $("#id").val(data.data.id);
                    $("#title").val(data.data.raw_translation_title.en);
                    $("#title_ku").val(data.data.raw_translation_title.ckb);
                    $("#title_ar").val(data.data.raw_translation_title.ar);
                    $("#longitude").val(data.data.longitude);
                    $("#latitude").val(data.data.latitude);
                    $("#radius").val(data.data.radius/1000);
                    $('#main_form_edit').attr('action', data.route);
                    $("#modal_form_vertical_edit").modal("show");

                }
            });
        })
    })
</script>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/location/script.blade.php ENDPATH**/ ?>