<!-- Vertical Edit form modal -->
<div id="modal_form_vertical_edit" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h5 class="modal-title text-white"><?php echo app('translator')->get('translate.edit_attribute'); ?></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="" class="form-validate-jquery main_form_edit" id="main_form_edit">
                    <?php echo e(method_field('PUT')); ?>

                    <?php echo e(csrf_field()); ?>



                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en_edit" class="nav-link active" data-toggle="tab">En</a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku_edit" class="nav-link" data-toggle="tab">Ku</a></li>
                        <li class="nav-item"><a href="#lang_ar_edit" class="nav-link" data-toggle="tab">Ar</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name" required id="name"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2">Select Category</label>
                                <select class="form-control" id="attribute_category_id_edit" name="category_id">
                                    <option value="0" selected>No Selectedt</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                        <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo $__env->make('categories.child_category', [
                                                'child_category' => $childCategory,
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.attribute_type'); ?></label>
                                <select name="attribute_type" id="attribute_type_edit" class="form-control">
                                    <option value="textarea" selected><?php echo app('translator')->get('translate.textarea'); ?></option>
                                    <option value="single_select"><?php echo app('translator')->get('translate.single_select'); ?></option>
                                    <option value="multi_select"><?php echo app('translator')->get('translate.multi_select'); ?></option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label class="form-label"><?php echo app('translator')->get('translate.attribute_priority'); ?></label>
                                <select name="priority" id="priority_edit" class="form-control">
                                    <option value="optional" selected><?php echo app('translator')->get('translate.optional'); ?></option>
                                    <option value="required"><?php echo app('translator')->get('translate.required'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name_ku" id="name_ku"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_name'); ?></label>
                                <input type="text" class="form-control" name="name_ar" id="name_ar"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_name'); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ml-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical Edit form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/attribute/update.blade.php ENDPATH**/ ?>