
<script src="<?php echo e(asset("global_assets/js/plugins/editors/ckeditor/ckeditor.js")); ?>"></script>
<script>
    $(document).ready(function () {

        CKEDITOR.replace('editor-full', {
            height: 400
        });
        CKEDITOR.replace('editor-full-ku', {
            height: 400
        });
        CKEDITOR.replace('editor-full-ar', {
            height: 400
        });

        CKEDITOR.replace('editor-full2', {
            height: 400
        });
        CKEDITOR.replace('editor-full2-ku', {
            height: 400
        });
        CKEDITOR.replace('editor-full2-ar', {
            height: 400
        });

        $("#info_table").DataTable({
            processing: true,
            "order": [[0, "desc"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/<?php echo e((App::getLocale() == 'ckb' ) ? 'ku' : App::getLocale()); ?>.json",
                searchPlaceholder: "<?php echo e(__('translate.search_records')); ?>"
            },
            serverSide: true,
            columnDefs: [{
                targets: [3]
            }],
            ajax: {
                url: "<?php echo e(route('help_feedback.data')); ?>"
            },
            columns: [
                {
                    data: "id",
                    name: "id"
                },
                {
                    data: "title",
                    name: "title",
                },
                {
                    data: "description",
                    name: "description",
                },
                {
                    data: "checkbox",
                    name: "checkbox",
                },
                {
                    data: "created_by",
                    name: "created_by"
                },
                {
                    data: "created_at",
                    name: "created_at"
                },
                {
                    data: "action",
                    name: "action",
                    "class": "text-center",
                }
            ]
        });


        $(document).on("click", "#edit", function () {
            var id = $(this).data('id');
            $.ajax({
                url: "<?php echo e(url('/help_feedback')); ?>/" + id+'/edit',
                type: "GET",
                dataType: "json",
                success: function (data) {
                    $("#id").val(data.data.id);
                    $("#title").val(data.data.raw_translation_title.en);
                    $("#title_ku").val(data.data.raw_translation_title.ku);
                    $("#title_ar").val(data.data.raw_translation_title.ar);
                    $("#description").val(data.data.raw_translation_description.en);
                    $("#description_ku").val(data.data.raw_translation_description.ckb);
                    $("#description_ar").val(data.data.raw_translation_description.ar);
                    CKEDITOR.instances["editor-full2"].setData(data.data.raw_translation_description.en);
                    CKEDITOR.instances["editor-full2-ku"].setData(data.data.raw_translation_description.ckb);
                    CKEDITOR.instances["editor-full2-ar"].setData(data.data.raw_translation_description.ar);
                    $('#main_form_edit').attr('action', data.route);
                    $("#modal_form_vertical_edit").modal("show");
                }
            });
        })
    })

</script>
<?php /**PATH /Users/miladmajeed/Desktop/Gigant/Sale-Point/resources/views/help_feedback/script.blade.php ENDPATH**/ ?>