<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom_uploader.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('translate.adds'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page_header'); ?>
    <!-- Basic button -->
    <div class="page-header page-header-light border rounded mb-3">
        <div class="page-header-content d-flex">
            <div class="page-title">
                <h5 class="mb-0"><?php echo app('translator')->get('translate.section_adds'); ?></h5>
                <div class="text-muted mt-1"><?php echo app('translator')->get('translate.adds_info'); ?></div>
            </div>
            <div class="my-auto ms-auto">

                <?php if($add->published == 0): ?>
                    <a  class="btn btn-outline-success" href="<?php echo e(route('add.change_publish',[$add->id])); ?>">Publish</a>
                <?php else: ?>
                    <a  class="btn btn-outline-danger" href="<?php echo e(route('add.change_publish',[$add->id])); ?>">Un Publish</a>
                <?php endif; ?>

            </div>
        </div>
        <div class="page-header-content border-top">
            <div class="breadcrumb">
                <a href="/" class="breadcrumb-item py-2"><?php echo app('translator')->get('translate.home'); ?></a>
                <span class="breadcrumb-item active py-2"><?php echo app('translator')->get('translate.adds'); ?></span>
            </div>
        </div>
    </div>
    <!-- /basic button -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content area -->
    <div class="content">

        <!-- Inner container -->
        <div class="d-flex align-items-stretch align-items-lg-start flex-column flex-lg-row">

            <!-- Left content -->
            <div class="flex-1 order-2 order-lg-1">

                <!-- Post -->
                <div class="card">
                    <div class="card-body">
                        <div class="mb-4">
                            <div class="mb-3 text-center">
                                <a href="#" class="d-inline-block">
                                    <img src="<?php echo e($thumbnail_image); ?>" class="img-fluid rounded" alt="">
                                </a>
                            </div>

                            <h3 class="card-title pt-2 mb-1">
                                <a href="#" class="text-body"><?php echo e($add->title); ?></a>
                            </h3>

                            <ul class="list-inline list-inline-bullet text-muted mb-3">
                                <li class="list-inline-item">By <a href="#"><?php echo e($add?->User?->fullname); ?></a></li>
                                <li class="list-inline-item"><?php echo e(\Carbon\Carbon::parse($add->created_at)->format('Y-m-d')); ?></li>

                            </ul>

                            <div class="mb-3">
                                <?php echo e($add->description); ?>

                            </div>

                        </div>

                        <div class="mb-4">

                            <table class="table">
                                <thead>
                                <?php $__currentLoopData = $attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $values): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($values['type'] != 'multi_select'): ?>
                                        <?php if($values['type'] == 'single_select'): ?>
                                            <tr>
                                                <th><?php echo e($values['key'] ?? ""); ?></th>
                                                <th>
                                                    <?php

                                                        $attr_value = \App\Models\AttributeValue::find($values['values']);
                                                        $attr_value_data = $attr_value?->value;
                                                    ?>

                                                    <?php echo e($attr_value_data); ?>

                                                </th>
                                            </tr>
                                        <?php else: ?>
                                            <tr>
                                                <th><?php echo e($values['key'] ?? ""); ?></th>
                                                <th><?php echo e($values['values'] ?? ""); ?></th>
                                            </tr>
                                        <?php endif; ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </thead>

                            </table>


                        </div>

                        <?php $__currentLoopData = $attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $values): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($values['type'] == 'multi_select'): ?>
                                <div>


                                    <h5><?php echo e($values['key']); ?></h5>


                                    <div class="row">

                                        <?php
                                                $attr_values_multi = \App\Models\AttributeValue::whereIn('id',explode(',' , $values['values']))->get();

                                        ?>

                                        <?php $__currentLoopData = $attr_values_multi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $multi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-4">
                                                <ul class="list list-unstyled">
                                                    <li>
                                                        <i class="ph-check-circle text-success me-2"></i>
                                                        <?php echo e($multi->value); ?>

                                                    </li>

                                                </ul>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </div>
                                </div>

                            <?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
                <!-- /post -->


                <!-- About author -->
                <div class="card">
                    <div class="card-header d-sm-flex border-bottom-0 pb-0">
                        <h5 class="mb-0">About the author</h5>

                    </div>

                    <div class="card-body d-flex flex-column flex-lg-row">
                        <div class="me-lg-3 mb-2 mb-lg-0">
                            <a href="#">
                                <img src="<?php echo e($add?->User?->image); ?>" class="rounded-circle" width="40" height="40" alt="">
                            </a>
                        </div>

                        <div class="flex-fill">
                            <h6 class="mb-1"><?php echo e($add?->User?->fullname); ?></h6>
                            <p><?php echo e($add?->User?->email); ?></p>
                            <p><?php echo e($add?->User?->phone); ?></p>


                        </div>
                    </div>
                </div>
                <!-- /about author -->


            </div>
            <!-- /left content -->


            <!-- Right sidebar component -->
            <div
                class="sidebar sidebar-component sidebar-expand-lg bg-transparent shadow-none order-1 order-lg-2 ms-lg-3 mb-3">

                <!-- Sidebar content -->
                <div class="sidebar-content">


                    <!-- Categories -->
                    <div class="card">
                        <div class="sidebar-section-header border-bottom">
                            <span class="fw-semibold">Categories</span>
                        </div>

                        <div class="nav nav-sidebar">

                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item">
                                    <a href="#" class="nav-link">
                                        <i class="ph-file-text me-2"></i>
                                        <?php echo e($category->title); ?>

                                        <span
                                            class="text-muted fs-sm fw-normal ms-auto"><?php echo e($category->multi_adds_count); ?></span>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </div>
                    </div>
                    <!-- /categories -->


                    <!-- Photos from Flickr -->
                    <div class="card">
                        <div class="sidebar-section-header border-bottom">
                            <span class="fw-semibold">Photos from Flickr</span>
                        </div>

                        <div class="sidebar-section-body">
                            <div class="row g-0">


                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col">
                                        <div class="card-img-actions">
                                            <a href="<?php echo e($image); ?>" class="text-white"
                                               data-bs-popup="lightbox">
                                                <img class="img-fluid rounded-top-start"
                                                     src="<?php echo e($image); ?>" alt="">
                                                <span class="card-img-actions-overlay rounded-top-start">
															<i class="ph-plus"></i>
														</span>
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </div>
                        </div>
                    </div>
                    <!-- /photos from Flickr -->


                </div>
                <!-- /sidebar content -->

            </div>
            <!-- /right sidebar component -->

        </div>
        <!-- /inner container -->

    </div>
    <!-- /content area -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('global_assets/js/vendor/editors/quill/quill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('global_assets/js/vendor/media/glightbox.min.js')); ?>"></script>

    <script src="<?php echo e(asset('global_assets/demo/pages/blog_single.js')); ?>"></script>
    <?php echo $__env->make('adds.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/adds/show.blade.php ENDPATH**/ ?>