<!-- Vertical form modal -->
<div id="modal_form_vertical" class="modal fade" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog ">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h6 class="modal-title"><?php echo app('translator')->get('translate.add_location'); ?></h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('location.store')); ?>" class="form-validate-jquery main_form"
                    id="main_form">
                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en" class="nav-link active"
                                data-toggle="tab"><?php echo app('translator')->get('translate.en'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku" class="nav-link" data-toggle="tab"><?php echo app('translator')->get('translate.ku'); ?></a>
                        </li>
                        <li class="nav-item"><a href="#lang_ar" class="nav-link" data-toggle="tab"><?php echo app('translator')->get('translate.ar'); ?></a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title"  required
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>

                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label class="mb-2"><?php echo app('translator')->get('translate.longitude'); ?></label>
                                        <input type="text" class="form-control" name="longitude" required
                                               placeholder="<?php echo app('translator')->get('translate.longitude'); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group mb-3">
                                        <label class="mb-2"><?php echo app('translator')->get('translate.latitude'); ?></label>
                                        <input type="text" class="form-control" name="latitude" required
                                               placeholder="<?php echo app('translator')->get('translate.latitude'); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.radius'); ?></label>
                                <input type="text" class="form-control" name="radius"
                                       placeholder="<?php echo app('translator')->get('translate.radius'); ?>">
                                <span class="text-muted"> From 1-500 km</span>
                            </div>

                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ku"
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.title'); ?></label>
                                <input type="text" class="form-control" name="title_ar"
                                    placeholder="<?php echo app('translator')->get('translate.title'); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /vertical form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/location/create.blade.php ENDPATH**/ ?>