<!-- Vertical Edit form modal -->
<script src="<?php echo e(asset("global_assets/js/plugins/forms/selects/select2.min.js")); ?>"></script>
<div id="modal_form_vertical_edit" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h5 class="modal-title text-white">Edit Category</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="" class="form-validate-jquery main_form_edit" id="main_form_edit">
                    <?php echo e(method_field('PUT')); ?>

                    <?php echo e(csrf_field()); ?>

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en_edit" class="nav-link active" data-toggle="tab">En</a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku_edit" class="nav-link" data-toggle="tab">Ku</a></li>
                        <li class="nav-item"><a href="#lang_ar_edit" class="nav-link" data-toggle="tab">Ar</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en_edit">
                            <div class="form-group mb-3">
                                <label class="mb-2">Title English</label>
                                <input type="text" class="form-control" name="title" required
                                       placeholder="Category Title" value="<?php echo e($category_update->title); ?>">
                            </div>
                            <div class="form-group mb-3">
                                <label class="mb-2">Parent</label>
                                <select class="select2 form-control parnet_id_update" name="parent_id">
                                    <option value="0">No Parent</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php if($category_update->parent_id== $category->id): ?> selected <?php endif; ?>><?php echo e($category->title); ?></option>
                                        <?php $__currentLoopData = $category->childrenCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $childCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo $__env->make('categories.child_category_update', ['child_category' => $childCategory], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group mb-3 row">
                                <label class="mb-2">Image</label>
                                <div class="input-group" data-toggle="aizuploader" data-type="image"
                                     data-multiple="false">
                                    <div class="input-group-prepend">
                                        <div
                                            class="input-group-text bg-soft-secondary font-weight-medium"><?php echo e(('Browse')); ?></div>
                                    </div>
                                    <div class="form-control file-amount"><?php echo e(('Choose File')); ?></div>
                                    <input type="hidden" name="image" value="<?php echo e($category_update->image); ?>" required
                                           class="selected-files">
                                    <small class="text-muted">These images are visible in product details page gallery. Use 600x600 sizes images.</small>
                                </div>
                                <div class="file-preview box sm"></div>
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku_edit">
                            <div class="form-group">
                                <label class="mb-2">Title Kurdish</label>
                                <input type="text" class="form-control" name="title_ku" placeholder="Title Kurdish"
                                       value="<?php echo e($category_update->getTranslation('title','ku',false)); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar_edit">
                            <div class="form-group">
                                <label class="mb-2">Title Arabic</label>
                                <input type="text" class="form-control" name="title_ar" placeholder="Title Arabic"
                                       value="<?php echo e($category_update->getTranslation('title','ar',false)); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form">Submit form <i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    $(".parnet_id_update").select2({
        placeholder: "Please Select Parent",
        dropdownParent: $("#modal_form_vertical_edit")
    })

    $("#category_type_id_edit").select2()
</script>
<!-- /vertical Edit form modal -->
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/categories/update.blade.php ENDPATH**/ ?>