<!-- vertical form modal -->
<div id="modal_form_vertical_attribute_value"
     class="modal fade modal_form_vertical_attribute_value" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-full">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white border-0">
                <h6 class="modal-title"><?php echo app('translator')->get('translate.add_attribute_value'); ?></h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form method="post" action="<?php echo e(route('attribute_value.store')); ?>"
                      class="form-validate-jquery main_form_add_attribute_value" id="main_form_add_attribute_value">
                    <?php echo e(csrf_field()); ?>

                    <input type="hidden" id="attribute_id" name="attribute_id" value="<?php echo e($attribute->id); ?>">

                    <ul class="nav nav-tabs nav-tabs-highlight nav-justified mb-4">
                        <li class="nav-item"><a href="#lang_en_attribute" class="nav-link active"
                                                data-toggle="tab">En</a>
                        </li>
                        <li class="nav-item"><a href="#lang_ku_attribute" class="nav-link" data-toggle="tab">Ku</a></li>
                        <li class="nav-item"><a href="#lang_ar_attribute" class="nav-link" data-toggle="tab">Ar</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="lang_en_attribute">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_value'); ?></label>
                                <input type="text" class="form-control" name="value" title="Required" required
                                       placeholder="<?php echo app('translator')->get('translate.attribute_value'); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ku_attribute">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_value'); ?></label>
                                <input type="text" class="form-control" name="value_ku" title="Required"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_value'); ?>">
                            </div>
                        </div>
                        <div class="tab-pane fade mb-3" id="lang_ar_attribute">
                            <div class="form-group mb-3">
                                <label class="mb-2"><?php echo app('translator')->get('translate.attribute_value'); ?></label>
                                <input type="text" class="form-control" name="value_ar" title="Required"
                                       placeholder="<?php echo app('translator')->get('translate.attribute_value'); ?>">
                            </div>
                        </div>
                    </div>


                    <div class="text-end">
                        <button type="submit" class="btn btn-dark submit_form"><?php echo app('translator')->get('translate.submit'); ?><i
                                class="icon-paperplane ms-2 send_icon"></i></button>
                    </div>
                </form>
            </div>
            <div class="modal-body">
                <table class="table table-hover" id="info_table_attribute_value">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Attribute</th>
                        <th>Attribute Value</th>
                        <th>Attribute Value Ku</th>
                        <th>Attribute Value ar</th>
                        <th></th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- /vertical form modal -->

<script>
    var info_table_attribute_value = $("#info_table_attribute_value").DataTable({
        "order": [[0, "desc"]],
        columnDefs: [{
            targets: [3]
        }], ajax: {
            url: "<?php echo e(route('attribute_value.data',[$attribute->id])); ?>"
        },
        columns: [
            {
                data: "id",
                name: "id"
            },
            {
                data: "attribute_name",
                name: "attribute_name",
            },
            {
                data: "value",
                name: "value",
            },
            {
                data: "value_ku",
                name: "value_ku",
            },
            {
                data: "value_ar",
                name: "value_ar",
            },
            {
                data: "action",
                name: "action",
                "class": "text-center",
            }
        ]
    });


</script>
<?php /**PATH /home/salepoint/admin.salepoint.store/resources/views/attribute/attribute_value.blade.php ENDPATH**/ ?>